; Back.s : 背景
;


; モジュール宣言
;
    .module Back

; 参照ファイル
;
    .include    "bios.inc"
    .include    "vdp.inc"
    .include    "System.inc"
    .include    "App.inc"
    .include    "Game.inc"
    .include	"Back.inc"

; 外部変数宣言
;
    .globl  _patternTable


; マクロの定義
;


; CODE 領域
;
    .area   _CODE

; 背景を初期化する
;
_BackInitialize::
    
    ; レジスタの保存

    ; 初期値の設定
    ld      hl, #backDefault
    ld      de, #_back
    ld      bc, #BACK_LENGTH
    ldir
    
    ; レジスタの復帰
    
    ; 終了
    ret

; 背景を更新する
;
_BackUpdate::
    
    ; レジスタの保存

    ; 地面のスクロール
    ld      a, (_back + BACK_SCROLL_GROUND)
    and     #0x01
    add     a, a
    ld      c, a
    add     a, a
    ld      d, a
    ld      e, #0x00
    ld      hl, #backPatternNameGround
    add     hl, de
    ld      a, (_back + BACK_SCROLL_GROUND)
    add     a, c
    and     #0x1e
    ld      d, e
    add     a, a
    rl      d
    add     a, a
    rl      d
    add     a, a
    rl      d
    add     a, a
    rl      d
    ld      e, a
    add     hl, de
    ld      de, #_appPatternName
    ld      bc, #0x0200
    ldir
    ld      hl, #_appPatternName
    ld      bc, #0x0100
    ldir
    ld      hl, #(_back + BACK_SCROLL_GROUND)
    dec     (hl)

    ; 壁のスクロール
    ld      a, (_back + BACK_SCROLL_WALL)
    and     #0x07
    add     a, a
    add     a, a
    add     a, a
    ld      e, a
    ld      d, #0x00
    ld      hl, #backPatternNameWall
    add     hl, de
    ld      de, #_appPatternName
    ld      c, #0x03
20$:
    ld      b, #0x08
    push    hl
21$:
    push    bc
    ld      bc, #0x0004
    ldir
    ld      bc, #(0x0020 - 0x0008)
    ex      de, hl
    add     hl, bc
    ex      de, hl
    ld      bc, #0x0004
    ldir
    pop     bc
    djnz    21$
    pop     hl
    dec     c
    jr      nz, 20$
    ld      hl, #(_back + BACK_SCROLL_WALL)
    dec     (hl)

    ; フェードイン
30$:
    ld      hl, #(_game + GAME_FLAG)
    bit     #GAME_FLAG_OVER_BIT, (hl)
    jr      nz, 40$
    ld      hl, #(_back + BACK_FADE)
    ld      a, (hl)
    or      a
    jr      z, 39$
    dec     (hl)
    ld      c, (hl)
    ld      hl, #(_appPatternName + 0x02ff)
    ld      b, #0x00
31$:
    ld      a, c
    sub     b
    jr      c, 33$
    cp      #0x04
    jr      c, 32$
    ld      a, #0x03
32$:
    add     a, #0x8c
    push    bc
    ld      e, l
    ld      d, h
    dec     hl
    ex      de, hl
    ld      bc, #(0x0020 - 0x0001)
    ld      (hl), a
    lddr
    dec     hl
    pop     bc
    jr      34$
33$:
    ld      de, #-0x0020
    add     hl, de
34$:
    inc     b
    ld      a, b
    cp      #0x18
    jr      c, 31$
39$:
    jr      90$

    ; フェードアウト
40$:
    ld      hl, #(_back + BACK_FADE)
    ld      c, (hl)
    ld      hl, #_appPatternName
    ld      b, #0x00
41$:
    ld      a, b
    cp      c
    jr      nc, 43$
    ld      a, c
    sub     b
    cp      #0x03
    jr      c, 42$
    ld      a, #0x03
42$:
    add     a, #0x8c
    push    bc
    ld      e, l
    ld      d, h
    inc     hl
    ex      de, hl
    ld      bc, #(0x0020 - 0x0001)
    ld      (hl), a
    ldir
    inc     hl
    pop     bc
    jr      44$
43$:
    ld      de, #0x0020
    add     hl, de
44$:
    inc     b
    ld      a, b
    cp      #0x18
    jr      c, 41$
    ld      hl, #(_back + BACK_FADE)
    ld      a, (hl)
    cp      #(0x18 + 0x04)
    jr      nc, 49$
    inc     (hl)
49$:
;   jr      90$

    ; 背景の完了
90$:

    ; レジスタの復帰
    
    ; 終了
    ret

; 背景を描画する
;
_BackRender::

    ; レジスタの保存

    ; レジスタの復帰

    ; 終了
    ret

; 背景が存在するかどうかを確認する
;
_BackIsAlive::

    ; レジスタの保存

    ; cf > 存在する

    ; 存在の確認
    ld      a, (_back + BACK_FADE)
    cp      #(0x18 + 0x04)

    ; レジスタの復帰

    ; 終了
    ret

; 背景がフェード中かどうかを確認する
;
_BackIsFade::

    ; レジスタの保存

    ; cf > フェード中

    ; フェードの確認
    ld      a, (_back + BACK_FADE)
    or      a
    jr      z, 10$
    scf
10$:

    ; レジスタの復帰

    ; 終了
    ret

; 定数の定義
;

; 背景の初期値
;
backDefault:

    .db     BACK_STATE_NULL
    .db     BACK_SCROLL_NULL
    .db     BACK_SCROLL_NULL
    .db     0x18 + 0x04

; パターンネーム
;

; 地面
backPatternNameGround:

    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x68, 0x64, 0x64, 0x64, 0x67, 0x62, 0x62, 0x62, 0x6c, 0x6d, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x6e, 0x6f, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x68, 0x64, 0x64, 0x64, 0x65, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x69, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x6a, 0x6b, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x6c, 0x6d, 0x62, 0x68, 0x64, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x67, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x6e, 0x6f, 0x62, 0x66, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x62, 0x62, 0x62, 0x66, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x62, 0x62, 0x62, 0x66, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x62, 0x62, 0x62, 0x66, 0x62, 0x69, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x69, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x62, 0x64, 0x64, 0x65, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x6a, 0x6b, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00

    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x68, 0x64, 0x64, 0x64, 0x67, 0x62, 0x62, 0x62, 0x6c, 0x6d, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x6e, 0x6f, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x68, 0x64, 0x64, 0x64, 0x65, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x69, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x6a, 0x6b, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x6c, 0x6d, 0x62, 0x68, 0x64, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x67, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x6e, 0x6f, 0x62, 0x66, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x62, 0x62, 0x62, 0x66, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x62, 0x62, 0x62, 0x66, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x62, 0x62, 0x62, 0x66, 0x62, 0x69, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x69, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x62, 0x62, 0x62, 0x66, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x62, 0x64, 0x64, 0x65, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x6a, 0x6b, 0x62, 0x62, 0x00, 0x00, 0x00, 0x00

    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x78, 0x74, 0x74, 0x74, 0x77, 0x72, 0x72, 0x72, 0x7c, 0x7d, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x7e, 0x7f, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x78, 0x74, 0x74, 0x74, 0x75, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x79, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x7a, 0x7b, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x7c, 0x7d, 0x72, 0x78, 0x74, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x77, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x7e, 0x7f, 0x72, 0x76, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x72, 0x72, 0x72, 0x76, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x72, 0x72, 0x72, 0x76, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x72, 0x72, 0x72, 0x76, 0x72, 0x79, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x79, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x72, 0x74, 0x74, 0x75, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x7a, 0x7b, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00

    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x78, 0x74, 0x74, 0x74, 0x77, 0x72, 0x72, 0x72, 0x7c, 0x7d, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x7e, 0x7f, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x78, 0x74, 0x74, 0x74, 0x75, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x79, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x7a, 0x7b, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x7c, 0x7d, 0x72, 0x78, 0x74, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x77, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x7e, 0x7f, 0x72, 0x76, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x72, 0x72, 0x72, 0x76, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x72, 0x72, 0x72, 0x76, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x72, 0x72, 0x72, 0x76, 0x72, 0x79, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x79, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x72, 0x72, 0x72, 0x76, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x72, 0x74, 0x74, 0x75, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x7a, 0x7b, 0x72, 0x72, 0x00, 0x00, 0x00, 0x00

; 壁
backPatternNameWall:

    .db     0x40, 0x41, 0x50, 0x58, 0x5e, 0x54, 0x48, 0x49
    .db     0x42, 0x43, 0x51, 0x59, 0x5f, 0x55, 0x4a, 0x4b
    .db     0x44, 0x45, 0x52, 0x5a, 0x5c, 0x56, 0x4c, 0x4d
    .db     0x46, 0x47, 0x53, 0x5b, 0x5d, 0x57, 0x4e, 0x4f
    .db     0x48, 0x49, 0x50, 0x58, 0x5e, 0x54, 0x40, 0x41
    .db     0x4a, 0x4b, 0x51, 0x59, 0x5f, 0x55, 0x42, 0x42
    .db     0x4c, 0x4d, 0x52, 0x5a, 0x5c, 0x56, 0x44, 0x43
    .db     0x4e, 0x4f, 0x53, 0x5b, 0x5d, 0x57, 0x46, 0x44

    .db     0x40, 0x41, 0x50, 0x58, 0x5e, 0x54, 0x48, 0x49
    .db     0x42, 0x43, 0x51, 0x59, 0x5f, 0x55, 0x4a, 0x4b
    .db     0x44, 0x45, 0x52, 0x5a, 0x5c, 0x56, 0x4c, 0x4d
    .db     0x46, 0x47, 0x53, 0x5b, 0x5d, 0x57, 0x4e, 0x4f
    .db     0x48, 0x49, 0x50, 0x58, 0x5e, 0x54, 0x40, 0x41
    .db     0x4a, 0x4b, 0x51, 0x59, 0x5f, 0x55, 0x42, 0x42
    .db     0x4c, 0x4d, 0x52, 0x5a, 0x5c, 0x56, 0x44, 0x43
    .db     0x4e, 0x4f, 0x53, 0x5b, 0x5d, 0x57, 0x46, 0x44


; DATA 領域
;
    .area   _DATA

; 変数の定義
;

; 背景
;
_back::

    .ds     BACK_LENGTH

